package com.polycom.sampleapps.servlet.user;

import java.util.Vector;

import javax.servlet.ServletConfig;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.data.UserProfile;

/**
 *
 * <p>Title: DeleteUserServlet</p>
 *
 * <p>Description: This servlet deletes the user from cache.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author NVS Anil
 * @version 1.0
 */
public class DeleteUserServlet extends HttpServlet implements SingleThreadModel
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doPost method from HttpServlet.
	 * Handles the POST request from IT Manager configuration and deletes the user.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doPost(HttpServletRequest a_request,
					   HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String errorMessage = "";
		String jspPage = "";
		boolean isITUser = false;
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user != null)
		{
			if (user.getType().equals(Constants.IT_USER_TYPE))
			{
				isITUser = true;
			}
		}
		if (user == null || !isITUser)
		{
			errorMessage = "Please login to delete users.";
			a_request.setAttribute("configure", "");
			jspPage = "/adminlogin.jsp";
			a_request.setAttribute("errormessage", errorMessage);
		}
		else
		{
			String delUserName = a_request.getParameter("user");
			//System.out.println("deleting user : " + delUserName);
			if (appContext.isUserExists(delUserName))
			{
				appContext.deleteUser(delUserName);
				Vector appContents = appContext.getUsers();
				a_request.setAttribute("contents", appContents);
				a_request.setAttribute("user", user);
				a_request.setAttribute("message1", "'" + delUserName +
									   "' deleted successfully.");
				jspPage = "/configureapps.jsp?op=adduser";
			}
			else
			{
				errorMessage = "Please login to delete users.";
				jspPage = "/adminlogin.jsp";
				a_request.setAttribute("errormessage", errorMessage);
			}
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
