package com.polycom.sampleapps.servlet.user;

import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.data.User;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.test.ProfileCreator;

/**
 *
 * <p>Title: LoginServlet</p>
 *
 * <p>Description:  This servlet checks the given Username and Passeords with the existing users.
 * This will handle login requests from Main_Browser and ADMIN login screens and redirects to the appropriate pages.
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author NVS Anil
 * @version 1.0
 */
public class LoginServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
		/////////TEMPORARY CODE TO WORK WITH SIMULATOR///////////////
		/*ProfileCreator pc = new ProfileCreator();
		int counter = 0;
		List<UserProfile> profiles = pc.createProfiles();
		for (UserProfile profile : profiles)
		{
			ApplicationContext.getInstance(m_config.getServletContext()).
				registerApplicationItemsWithRefreshManager(profile);
			counter++;
			if (counter == 50)
			{
				break;
			}
		}
		System.out.println("total profile : " + counter);*/
		/////////END TEMPORARY CODE TO WORK WITH SIMULATOR///////////////
	}

	/**
	 * Overrided doPost method from HttpServlet.
	 * Handles the POST request from login page for IT Manager/User.
	 * validates the UserName and Password with existing users and redirects to the appropriate pages.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doPost(HttpServletRequest a_request,
					   HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		boolean isLoginSuccess = false;
		String errorMessage = "";
		User user = null;
		// GETTING USERNAME AND PASSWORD FROM HTTP REQUEST
		String userName = a_request.getParameter("username");
		String password = a_request.getParameter("password");
		if (userName == null || userName.length() == 0)
		{
			errorMessage = "Please enter valid User Name.";
		}
		else if (password == null || password.length() == 0)
		{
			errorMessage = "Please enter valid Password.";
		}
		else
		{
			// CHECK USERNAME AND PASSWORD ARE ALREADY EXISTS
			//ApplicationContext.logger.log(Level.INFO, "Logging UserName : " + userName);
			//ApplicationContext.logger.log(Level.INFO, "Logging Password : " + password);
			// GETTING EXISTING USERS FROM APPLICATIONCONTEXT CACHE
			Vector<User> usersList = appContext.getUsers();
			for (User tempUser : usersList)
			{
				if (tempUser.getName().equals(userName))
				{
					user = tempUser;
					if (tempUser.getPassword().equals(password))
					{
						// CHECKING FOR CONFIGURE PARAMETER TO MAKE SURE THIS IS COMING FROM ADMIN CONFIGURATION
						isLoginSuccess = true;
						break;
					}
					else
					{
						errorMessage = "Invalid Password.";
						break;
					}
				}
				else
				{
					errorMessage = "Invalid User Name.";
				}
			}
		}
		String jspPage = "";
		if (isLoginSuccess)
		{
			UserProfile userProfile = appContext.getUser(user.getName(),
				a_request.getRemoteAddr());
			ApplicationContext.logger.log(Level.INFO,userProfile.getName());
			// LOGIN IS SUCCESSFULL, REDIRECTING TO APPROPRIATE PAGE
			if (a_request.getParameter("configure") != null)
			{
				appContext.addUsernameCookieToTheResponse(a_response,
					userProfile.getUser(), false);
				a_request.setAttribute("user", userProfile);
				jspPage = "/configureapps.jsp";
			}
			else
			{
				if (user.getType().equals(Constants.IT_USER_TYPE))
				{
					jspPage = "/login.jsp";
					a_request.setAttribute("errormessage", "Invalid User Name.");
				}
				else
				{
					// REGISTER ITEMS WITH REFRESH MANAGER
					appContext.registerApplicationItemsWithRefreshManager(
						userProfile);
					// ADDING PERMANENT COOKIE TO THE RESPONSE
					appContext.addUsernameCookieToTheResponse(a_response,
						userProfile.getUser(), true);
					jspPage = "/applications.jsp";
					a_request.setAttribute("applicationlist",
										   userProfile.getEnabledApplications());
				}
			}
		}
		else
		{
			// LOGIN UNSUCCESSFUL, REDIRECTING TO LOGIN PAGE WITH ERROR INFORMATION
			a_request.setAttribute("errormessage", errorMessage);
			if (a_request.getParameter("configure") != null)
			{
				jspPage = "/adminlogin.jsp";
			}
			else
			{
				jspPage = "/login.jsp";
			}
		}
		appContext.forward(a_request, a_response, jspPage);
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles the GET request from Main-Browser. This will handle one-time login session for users.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String jspPage = "";
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user == null)
		{
			// SHOW LOGIN PAGE
			jspPage = "/login.jsp";
		}
		else
		{
			ApplicationContext.logger.log(Level.INFO,
										  "User from Main-Browser : " +
										  user.getName());
			if (user.getStockApplication() != null)
			{
				user.getStockApplication().setLastViewedStock(null);
			}
			if (user.getWeatherApplication() != null)
			{
				user.getWeatherApplication().setLastViewedLocation(null);
			}
			// DISPLAY APPLICATIONS PAGE BASED ON COOKIE USERNAME
			jspPage = "/applications.jsp";
			a_request.setAttribute("applicationlist",
								   user.getEnabledApplications());
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
