package com.polycom.sampleapps.servlet.user;

import java.io.File;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.data.UserProfile;

/**
 *
 * <p>Title: LogoutServlet</p>
 *
 * <p>Description: Saves the configured information and then removes the user from cache.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author NVS Anil
 * @version 1.0
 */
public class LogoutServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles the request from all pages to logout the configuration session
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		// GETING UERNAME FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user != null)
		{
			appContext.logoutUser(user.getName(), a_request.getRemoteAddr());
		}
		else
		{
			// DO NOTHING
		}
		a_request.setAttribute("configure", "");
		String jspPage = "/adminlogin.jsp";
		appContext.forward(a_request, a_response, jspPage);
	}
}
