package com.polycom.sampleapps.servlet.weather;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.RefreshManager;
import com.polycom.sampleapps.servlet.common.data.Application;
import com.polycom.sampleapps.servlet.common.data.Item;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.exception.ItemNotRegisteredException;
import com.polycom.sampleapps.servlet.exception.LocationAlreadyExistException;

/**
 *
 * <p>Title: AddStockServlet</p>
 *
 * <p>Description: This class adds new zip/city codes for IT Manager/Users.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class AddLocationServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doPost method from HttpServlet.
	 * Handles the POST request from addloc/viewlocations.jsp page to add new zip/city codes for IT manager/USER.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doPost(HttpServletRequest a_request,
					   HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());

		String message = "";
		String jspPage = "";
		boolean isLocationAdded = false;
		boolean isLocationAddFailed = false;
		boolean isItUser = false;
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		Application app = null;
		if (user != null)
		{
			app = user.getWeatherApplication();
			if (user.getType().equals(Constants.IT_USER_TYPE))
			{
				isItUser = true;
				a_request.setAttribute("enabled", "" + app.isEnabled());
				a_request.setAttribute("application", app);
			}
		}
		// STEP 1: GET UERNAME
		String locname = a_request.getParameter("locname");
		if (user == null)
		{
			message = "Please login to add weather location.";
		}
		else
		{
			if (locname == null || locname.getBytes().length <= 0)
			{
				message = "Please enter valid Zip/City code.";
				isLocationAddFailed = true;
			}
			else
			{
				boolean locFlag = true;
				try
				{
					//RefreshManager manager = appContext.getWeatherRefreshManager();
					WeatherManager manager=appContext.getWeatherManager();
					boolean isExist = manager.isSymbolExists(locname);
					if (!isExist)
					{
						message = manager.isValidWeatherSymbol(locname);
						if ( message.length() == 0 )
						{
							isExist = true;
							manager.add(locname);
						}
						/*manager.register(locname);
						WeatherInfo weatherInfo = null;
						try
						{
							for (int i = 0; i < Constants.NUMBER_OF_RETRIES; i++)
							{
								weatherInfo = (WeatherInfo) manager.
									getResult(locname);
								if (weatherInfo != null)
								{
									break;
								}
							}
						}
						catch (ItemNotRegisteredException ex3)
						{
						}
						if (weatherInfo != null)
						{
							if (weatherInfo.getTemperature() != null &&
								weatherInfo.getTemperature().length() > 0)
							{
								isExist = true;
							}
							else
							{
								message = "Please enter valid Zip/City code.";
							}
						}
						else
						{
							manager.unregister(locname);
							message =
								"Unable to add Locations. Please try after some time.";
						}*/
					}
					if (isExist)
					{
						// do nothing
					}
					else
					{
						locFlag = false;
					}
				}
				catch (Exception ex2)
				{
					locFlag = false;
					ApplicationContext.logger.log(Level.SEVERE,
												  ex2.getMessage(), ex2);
				}
				if (locFlag)
				{
					try
					{
						user.addLocation(locname);
						message = "'" + locname + "' added successfully.";
						// REGISTER THE ADDED WEATHER LOCATION WITH REFRESH MANAGER
						/*if (!user.isITUser())
						{
							appContext.getWeatherRefreshManager().register(
								locname);
						}*/

						isLocationAdded = true;
					}
					catch (LocationAlreadyExistException ex)
					{
						isLocationAddFailed = true;
						message = ex.getMessage();
					}
				}
				else
				{
					isLocationAddFailed = true;
				}
			}
		}

		if (isLocationAdded || (isLocationAddFailed && !isItUser))
		{
			// PERSIST USER
			try
			{
				user.persistUserProfile(appContext);
			}
			catch (IOException ex1)
			{
				ApplicationContext.logger.log(Level.SEVERE, ex1.getMessage(),
											  ex1);
			}
			if (isItUser)
			{
				Vector<Item> appContents = user.getWeatherApplication().
					getItems();
				appContext.addUsernameCookieToTheResponse(a_response,
					user.getUser(), false);
				a_request.setAttribute("contents", appContents);
				a_request.setAttribute("message", message);
				a_request.setAttribute("user", user);
				jspPage = "/configureapps.jsp?op=addloc";
			}
			else
			{
				Vector<Item> locations = user.getWeatherLocations();
				if (isLocationAddFailed)
				{
					a_request.setAttribute("message", message);

					//Item location = locations.get(0);
					List<Item> dispLocs = new ArrayList<Item> ();
					dispLocs.addAll(locations);
					a_request.setAttribute("locations", dispLocs);
					//a_request.setAttribute("location", location);
					//a_request.setAttribute("locimagefile", "");
					jspPage = "/viewlocations.jsp";
				}
				else if (locations.size() > 0)
				{
					boolean locFlag = true;
					String locImageFile = "";
					Item location = locations.get(0);
					a_request.setAttribute("location", location);
					a_request.setAttribute("locations",
										   user.getWeatherLocations());
					a_request.setAttribute("locbmpfile", locImageFile);
					if (!locFlag)
					{
						String errorMessage = locname +
							" forecast not available";
						a_request.setAttribute("errormessage", errorMessage);
					}
					a_response.setHeader("Expires", "0");
					jspPage = "/viewlocations.jsp";
				}
			}
		}
		else
		{
			if (a_request.getParameter("configure") != null)
			{
				if (user == null)
				{
					a_request.setAttribute("errormessage", message);
					a_request.setAttribute("configure", "");
					jspPage = "/adminlogin.jsp";
				}
				else
				{
					a_request.setAttribute("contents", app.getItems());
					a_request.setAttribute("user", user);
					a_request.setAttribute("message", message);
					jspPage = "/configureapps.jsp?op=addloc";
				}
			}
			else
			{
				a_request.setAttribute("errormessage", message);
				jspPage = "/login.jsp";
			}
		}

		if(jspPage==null||jspPage.trim().equals(""))
		{
			if (user == null)
			{
				a_request.setAttribute("errormessage", message);
				jspPage = "/adminlogin.jsp";
			}
			else
			{
				message =
					"Unable to add Locations/Invalid code. Please try after some time.";
				a_request.setAttribute("errormessage", message);
				jspPage = "/viewlocations.jsp";
			}
		}
		appContext.forward(a_request, a_response, jspPage);
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles the GET request from addloc/viewlocations.jsp page for IT Manager/USER.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		Application app = null;
		if (user != null)
		{
			boolean isItUser = false;
			app = user.getWeatherApplication();
			if (user.getType().equals(Constants.IT_USER_TYPE))
			{
				isItUser = true;
				a_request.setAttribute("enabled", "" + app.isEnabled());
				a_request.setAttribute("application", app);
			}
			if (isItUser)
			{
				Vector<Item> appContents = user.getWeatherApplication().
					getItems();
				appContext.addUsernameCookieToTheResponse(a_response,
					user.getUser(), false);
				a_request.setAttribute("contents", appContents);
				a_request.setAttribute("user", user);
				jspPage = "/configureapps.jsp?op=addloc";
			}
			else
			{
				Vector<Item> locations = user.getWeatherLocations();
				if (locations.size() > 0)
				{
					Item location = locations.get(0);
					List<Item> dispLocs = new ArrayList<Item> ();
					dispLocs.addAll(locations);
					//dispLocs.remove(0);
					a_request.setAttribute("locations", dispLocs);
					a_request.setAttribute("location", location);
					a_request.setAttribute("locimagefile", "");
				}
				else
				{
					a_request.setAttribute("message",
										   "Zip/City codes not configured.");
				}
				jspPage = "/viewlocations.jsp";
			}
		}
		else
		{
			String message = "Please login to add Zip/City codes.";
			if (a_request.getParameter("configure") != null)
			{
				a_request.setAttribute("errormessage", message);
				jspPage = "/adminlogin.jsp";
			}
			else
			{
				a_request.setAttribute("errormessage", message);
				jspPage = "/login.jsp";
			}
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
