package com.polycom.sampleapps.servlet.weather;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.data.Application;
import com.polycom.sampleapps.servlet.common.data.Item;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.common.persistance.PersistApplications;
import com.polycom.sampleapps.servlet.common.persistance.PersistUser;

/**
 *
 * <p>Title: ConfigureLocationServlet</p>
 *
 * <p>Description: This servlet configures (Add/Delete from home page) the Locations.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class ConfigureLocationServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles the GET request from viewstocks.jsp page to configure locations for Users.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());

		String errorMessage = "";
		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user == null)
		{
			errorMessage = "Please login to configure Locations.";
			a_request.setAttribute("errormessage", errorMessage);
			jspPage = "login.jsp";
		}
		else
		{
			String locName = "";
			boolean delete = false;
			if (a_request.getParameter("dellochome") != null)
			{
				locName = a_request.getParameter("dellochome");
				user.deleteLocationFromHomePage(locName);
				delete = true;
			}
			else if (a_request.getParameter("addlochome") != null)
			{
				locName = a_request.getParameter("addlochome");
				user.addLocationToHomePage(locName);
			}
			// PERSIST USER
			try
			{
				String userFilePath = appContext.getXmlDirPath() +
					user.getName() + ".xml";
				PersistUser.persist(user, userFilePath);
			}
			catch (IOException ex1)
			{
				ApplicationContext.logger.log(Level.SEVERE, ex1.getMessage(),
											  ex1);
			}
			Vector<Item> locations = user.getWeatherLocations();
			Application app = user.getWeatherApplication();
			List<Item> dispLocs = new ArrayList<Item> ();
			Item location = null;
			int index = 0;
			for (Item cApp : app.getItems())
			{
				if (cApp.getName().equals(locName))
				{
					location = cApp;
					break;
				}
				index++;
			}
			if (delete)
			{
				user.getWeatherLocations().remove(index);
				user.getWeatherLocations().add(location);
			}
			else
			{
				user.getWeatherLocations().remove(index);
				user.getWeatherLocations().add(0, location);
			}
			dispLocs.addAll(locations);
			//dispLocs.remove(0);
			a_request.setAttribute("locations", dispLocs);
			a_request.setAttribute("location", location);
			a_request.setAttribute("locimagefile", "");
			jspPage = "/viewlocations.jsp";
		}
		appContext.forward(a_request, a_response, jspPage);
	}

	/**
	 * Overrided doPost method from HttpServlet.
	 * Handles the POST request from configurelocation.jsp page to configure locations for IT manager.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doPost(HttpServletRequest a_request,
					   HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());

		String errorMessage = "";
		String jspPage = "";
		boolean isItUser = false;
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user != null)
		{
			Application app = user.getWeatherApplication();
			if (user.getType().equals(Constants.IT_USER_TYPE))
			{
				isItUser = true;
				a_request.setAttribute("enabled", "" + app.isEnabled());
				a_request.setAttribute("application", app);
			}
		}
		if (user == null)
		{
			errorMessage = "Please login to configure Locations.";
			a_request.setAttribute("errormessage", errorMessage);
			jspPage = "/adminlogin.jsp";
		}
		else
		{
			String locName = "";
			if (a_request.getParameter("dellochome") != null)
			{
				locName = a_request.getParameter("dellochome");
				user.deleteLocationFromHomePage(locName);
				a_request.setAttribute("message1",
									   locName + " disabled for home page.");
			}
			else if (a_request.getParameter("addlochome") != null)
			{
				locName = a_request.getParameter("addlochome");
				user.addLocationToHomePage(locName);
				a_request.setAttribute("message1",
									   locName + " enabled for home page.");
			}
			else if (a_request.getParameter("delloc") != null)
			{
				locName = a_request.getParameter("delloc");
				user.deleteLocation(locName);
				a_request.setAttribute("message1",
									   locName + " deleted successfully.");
			}
			// PERSIST USER
			try
			{
				String userFilePath = "";
				if (isItUser)
				{
					userFilePath = appContext.getXmlDirPath() +
						Constants.APPLICATIONS_XML_FILE;
					PersistApplications.persist(user, userFilePath);
				}
				else
				{
					userFilePath = appContext.getXmlDirPath() + user.getName() +
						".xml";
					PersistUser.persist(user, userFilePath);
				}
			}
			catch (IOException ex1)
			{
				ApplicationContext.logger.log(Level.SEVERE, ex1.getMessage(),
											  ex1);
			}
			appContext.addUsernameCookieToTheResponse(a_response, user.getUser(), false);
			Vector<Item> appContents = user.getWeatherLocations();
			a_request.setAttribute("contents", appContents);
			a_request.setAttribute("user", user);
			jspPage = "/configureapps.jsp?op=addloc";
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
