package com.polycom.sampleapps.servlet.weather;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultClientIOEventDispatch;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.protocol.BufferingHttpClientHandler;
import org.apache.http.nio.protocol.HttpRequestExecutionHandler;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExecutionContext;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.EntityUtils;

import com.polycom.sampleapps.servlet.stocks.SymbolKey;

/**
*
* <p>Title: NIOForWeather</p>
*
* <p>Description: The class uses apache NIO to update the weather content for given weather item
* It create sockets for every stock symbol ,connects to the url given,gets the data from site and updates the weather information.
* </p>
*
* <p>Copyright:* Copyright (c) 2007 Polycom Canada Ltd.</p>
*
* <p>Company: Polycom, Inc</p>
*
* @author M Sandeep
* @version 1.0
*/

public class NIOForWeather {
	
	public static final String WEATHER_CONTENT_PROVIDER_URL = "www.weather.com";
	public static final String WEATHER_QUERY_URI = "/weather/local/";

	private static Hashtable<String, String> htStockFiles = new Hashtable<String, String>();

	private Vector<String> m_stockSymbols;

	WeatherBMPMaker m_sbc;
	
	private ConnectingIOReactor ioReactor;

	public NIOForWeather(Vector<String> stockSymbols, WeatherBMPMaker bmpConverter)
	{
		m_sbc = bmpConverter;
		m_stockSymbols = stockSymbols;
		htStockFiles.clear();
		final HttpParams params = new BasicHttpParams(null);
		params
				.setIntParameter(HttpConnectionParams.SO_TIMEOUT, 50000)
				.setIntParameter(HttpConnectionParams.CONNECTION_TIMEOUT, 70000)
				.setIntParameter(HttpConnectionParams.SOCKET_BUFFER_SIZE,
						8 * 1024).setBooleanParameter(
						HttpConnectionParams.STALE_CONNECTION_CHECK, false)
				.setBooleanParameter(HttpConnectionParams.TCP_NODELAY, true)
				.setParameter(HttpProtocolParams.USER_AGENT,
						"Jakarta-HttpComponents-NIO/1.1");

		try
		{
			ioReactor = new DefaultConnectingIOReactor(2, params);
			BasicHttpProcessor httpproc = new BasicHttpProcessor();
			httpproc.addInterceptor(new RequestContent());
			httpproc.addInterceptor(new RequestTargetHost());
			httpproc.addInterceptor(new RequestConnControl());
			httpproc.addInterceptor(new RequestUserAgent());
			httpproc.addInterceptor(new RequestExpectContinue());
	
			BufferingHttpClientHandler handler = new BufferingHttpClientHandler(
					httpproc, new MyWeatherHttpRequestExecutionHandler(),
					new NoConnectionReuseStrategy(), params);
	
			
	
			final IOEventDispatch ioEventDispatch = new DefaultClientIOEventDispatch(
					handler, params);
	
			//	Initializes the NIO process to select the socket channels 
			Thread t = new Thread(new Runnable() {
				public void run() {
					try {
						ioReactor.execute(ioEventDispatch);
					} catch (InterruptedIOException ex) {
						System.err.println("Interrupted");
					} catch (IOException e) {
						System.err.println("I/O error: " + e.getMessage());
					}
				}
			});
			t.start();
	
			SessionRequest[] reqs = new SessionRequest[m_stockSymbols.size()];
			int counter = 0;
			for (String symbol : m_stockSymbols) {
				SymbolKey quoteKey = new SymbolKey(WEATHER_QUERY_URI + symbol,
						new HttpHost(WEATHER_CONTENT_PROVIDER_URL));
				reqs[counter++] = ioReactor.connect(new InetSocketAddress(
						WEATHER_CONTENT_PROVIDER_URL, 80), null, quoteKey, null);
			}
		} catch (Exception e) {
		}
	}
	
	/**
	 * Closes all the opened socket channel
	 *
	 */
	public void shutDownClient()
	{
		try {
			if (ioReactor != null)
				ioReactor.shutdown();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Description:Used to initialize the connection,submitting the request and handling the response.
	 * The data obtained in response is updated in weather data map for creating weather info objects
	 * @author smarella
	 *
	 */
	class MyWeatherHttpRequestExecutionHandler implements
			HttpRequestExecutionHandler {

		public void initalizeContext(final HttpContext context,
				final Object attachment) {
			// HttpHost targetHost = (HttpHost) attachment;
			SymbolKey chartKey = (SymbolKey) attachment;
			context.setAttribute("URI", chartKey.getURI());
			context.setAttribute(HttpExecutionContext.HTTP_TARGET_HOST,
					chartKey.getHttpHost()); // targetHost);
		}

		public HttpRequest submitRequest(final HttpContext context) {

			HttpHost targetHost = (HttpHost) context
					.getAttribute(HttpExecutionContext.HTTP_TARGET_HOST);
			String uri = (String) context.getAttribute("URI");			
			BasicHttpRequest req = new BasicHttpRequest("GET", uri);
			return req;
		}

		public void handleResponse(final HttpResponse response,
				final HttpContext context) {
			HttpEntity entity = response.getEntity();

			String uri = (String) context.getAttribute("URI");
			if (uri != null&&m_sbc!=null) {
				try {
					String symbol = getSymbol(uri);

						m_sbc.getWeatherTable().put(symbol, EntityUtils.toString(entity));
				} catch (IOException ex) {
					System.err.println("I/O error: " + ex.getMessage());
				}
				
			}
		}

		private String getSymbol(String aUri) {
			String result = null;
			result = aUri.substring(WEATHER_QUERY_URI.length());
			return result;
		}

	}

}
