package com.polycom.sampleapps.servlet.weather;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.data.Application;
import com.polycom.sampleapps.servlet.common.data.Item;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.common.persistance.PersistUser;

/**
 *
 * <p>Title: ViewLocationServlet</p>
 *
 * <p>Description: This servlet displays selected location weather forecast for users.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class ViewLocationServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles request from viewstocks.jsp to display selected stock chart for users.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String errorMessage = "";
		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user == null)
		{
			errorMessage = "Please login to view weather forecast.";
			jspPage = "/login.jsp";
			a_request.setAttribute("errormessage", errorMessage);
		}
		else
		{
			Vector<Item> locs = user.getWeatherLocations();
			String locName = (String) a_request.getParameter("locname");
			Item location = null;
			for (Item cApp : locs)
			{
				if (cApp.getName().equals(locName))
				{
					location = cApp;
					break;
				}
			}
			String locFileName = "";
			boolean locFlag = true;
			if (location != null)
			{
				Application app = user.getWeatherApplication();
				Item lastViewedLoc = app.getLastViewedLocation();
				if (lastViewedLoc != null)
				{
					// DISPLAY STOCK AS PER SELECTED STOCKNAME
					Item tempApp = locs.get(0);
					user.getWeatherLocations().remove(0);
					locs = user.getWeatherLocations();
					// ADDING DISPLAYED STOCK IN LAST POSITION
					int index = 0;
					for (Item cApp : locs)
					{
						if (cApp.isAddedToHomePage())
						{
							// do nothing
						}
						else
						{
							break;
						}
						index++;
					}
					user.getWeatherLocations().add(index, tempApp);
				}
				app.setLastViewedLocation(location);
				//int index = user.getWeatherLocations().indexOf(location);
				// REMOVING DISPLAY STOCK FROM STOCKS
				Iterator it = locs.iterator();
				while (it.hasNext())
				{
					Item tempStock = (Item) it.next();
					if (tempStock.getName().equals(location.getName()))
					{
						it.remove();
						break;
					}
				}
				// ADDING DISPLAY STOCK AT ZERO POSITION
				user.getWeatherLocations().add(0, location);
				// PERSIST USER
				try
				{
					String userFilePath = appContext.getXmlDirPath() +
						user.getName() + ".xml";
					PersistUser.persist(user, userFilePath);
				}
				catch (IOException ex1)
				{
					ApplicationContext.logger.log(Level.SEVERE, ex1.getMessage(),
												  ex1);
				}
			}
			if (locFlag)
			{
				File file = new File(locFileName);
				a_request.setAttribute("locbmpfile", file.getName());
				a_request.setAttribute("location", location);
				a_request.setAttribute("locations", user.getWeatherLocations());
			}
			else
			{
				a_request.setAttribute("location", location);
				errorMessage = location.getName() +
					" weather forecast not available";
				a_request.setAttribute("errormessage", errorMessage);
			}
			jspPage = "/viewlocations.jsp";
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
