package com.polycom.sampleapps.servlet.weather;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.data.Item;
import com.polycom.sampleapps.servlet.common.data.UserProfile;

/**
 *
 * <p>Title: ViewLocationsServlet</p>
 *
 * <p>Description: This servlet displays weather for selected zip/cities for Users.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class ViewLocationsServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles request from applications.jsp to display enabled zip/citie codes.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String errorMessage = "";
		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user == null)
		{
			errorMessage = "Please login to view stocks page.";
			jspPage = "/login.jsp";
			a_request.setAttribute("errormessage", errorMessage);
		}
		else
		{
			// STEP 2: GET STOCKS FROM CACHE
			Vector<Item> locations = user.getWeatherLocations();
			String locName = (String) a_request.getParameter("locname");
			List<Item> dispLocs = new ArrayList<Item> ();
			Item location = null;
			if (locName == null)
			{
				// DISPLAY FIRST STOCK
				if (locations.size() > 0)
				{
					location = locations.get(0);
					dispLocs.addAll(locations);
				}
				else
				{
					errorMessage = "Zip/City codes not configured.";
					a_request.setAttribute("message", errorMessage);
				}
			}
			else
			{
				location = locations.get(0);
				dispLocs.addAll(locations);
			}
			a_request.setAttribute("locations", dispLocs);
			a_request.setAttribute("location", location);
			a_request.setAttribute("locimagefile", "");
			jspPage = "/viewlocations.jsp";
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
