package com.polycom.sampleapps.servlet.weather;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;

import javax.imageio.ImageIO;
import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.CheckURL;


/**
*
* <p>Title: WeatherBMPMaker</p>
*
* <p>Description: Creates weather info object which will be used by manager for sending response to phone.
* This class has utility methods to create weather info object using the weather data obtained from NIO for weather </p>
*
* <p>Copyright:* Copyright (c) 2007 Polycom Canada Ltd.</p>
*
* <p>Company: Polycom, Inc</p>
*
* @author M Sandeep
* @version 1.0
*/
public class WeatherBMPMaker extends Thread {
	private static final int POLL_PERIOD = 5 * 60 * 1000; // 3mins

	private WeatherManager m_manager;

	private static int weathersCreated = 1;

	Hashtable<String, byte[]> weatherImageHt;

	Hashtable<String, String> weatherContentHT;

	private static Hashtable<String, byte[]> weatherImageBytesHT;
	
	public WeatherBMPMaker(WeatherManager manager) {
		m_manager = manager;
		weatherImageHt = new Hashtable<String, byte[]>();
		weatherContentHT = new Hashtable<String, String>();
		weatherImageBytesHT=new Hashtable<String, byte[]>();
		
	}

	public Hashtable<String, String> getWeatherTable() {
		return weatherContentHT;
	}

	
	/**
	 * Creates weather info objects for currently configured weather items
	 */
	public void run() {
		while (true) {
			try {
				// System.out.println("In BMP converter");
				this.sleep(POLL_PERIOD);
					createImages();
			} catch (Exception ex) {
				ApplicationContext.logger.log(Level.SEVERE,
				  "Error in converting weather BMP");
				//ex.printStackTrace();
			}
		}
	}

	/**
	 * Gets currently configured weather items and creates weather info object for every item.
	 *
	 */
	private void createImages() {
		String bmpFolder = m_manager.getlocationsBmpPath();
		Vector<String> activeItems = m_manager.getActiveItems();
				for (String stock : activeItems) {
					if (weatherContentHT.containsKey(stock)) {
						try {
							String quoteHtml = weatherContentHT.get(stock);
							WeatherInfo info = createBMP(stock, quoteHtml, bmpFolder);
							if (info != null)
								m_manager.getWeatherInfoHt().put(stock, info);
						} catch (Exception e) {
							e.printStackTrace();
						}
					}
				}
	
	}

	/**
	 * Parses the weather content,creates the weather image symbol and creates the weather info object 
	 * @param a_itemName
	 * @param content
	 * @param bmpLocation
	 * @return
	 */
	public static WeatherInfo createBMP(String a_itemName, String content,
			String bmpLocation) {
		
		if(weatherImageBytesHT==null)
		{
			weatherImageBytesHT=new Hashtable<String, byte[]>();
		}
		
		WeatherInfo weatherInfo = null;
		if (content != null) {
			try {
				WeatherHtmlParser htmlParser = new WeatherHtmlParser();
				htmlParser.readWeatherContent(content);

				// CREATE STOCK INFO AND CACHE IT AGAINST ITEM
				if (weathersCreated == 50000) {
					weathersCreated = 1;
				}
				// byte[] chartBytes=getChartBytes(htmlParser.getImageURL());
				// byte[] chartBytes =
				// getChartBytes("http://image.weather.com/web/common/wxicons/52/32.gif?12122006");
				//String url = "http://image.weather.com/web/common/wxicons/52/32.gif?12122006";
				String url=htmlParser.getImageURL();
				byte[] chartBytes =null;
				if(url!=null)
				{
					if(!weatherImageBytesHT.containsKey(url))
					{
						chartBytes = getChartBytes(url);
						if(chartBytes!=null)
							weatherImageBytesHT.put(url, chartBytes);
					}else
					{
						chartBytes=weatherImageBytesHT.get(url); 
					}
					
				}

				if (chartBytes != null && chartBytes.length > 0) {
					String bmpFileName = a_itemName + "_" + weathersCreated
							+ ".bmp";
					String filePath = bmpLocation + File.separator
							+ bmpFileName;
					weatherInfo = new WeatherInfo(htmlParser.getTitle(),
							htmlParser.getTemperature(), htmlParser
									.getHumidity(),
							htmlParser.getCloudStatus(), htmlParser.getWind(),
							chartBytes, bmpFileName);

					BufferedImage source = ImageIO
							.read(new ByteArrayInputStream(chartBytes));

					boolean isImageCreated = ImageIO.write(source, "bmp",
							new File(filePath));

					if (isImageCreated) {
						weathersCreated++;
						return weatherInfo;
					}
				}
			} catch (Exception e) {
				ApplicationContext.logger.log(Level.SEVERE,
						  "Error in converting weather BMP");
			}
		}
		return weatherInfo;
	}

	
	/**
	 * Utilty method to get the weather image information using the imageLocation url 
	 * @param imageLocation
	 * @return
	 */
	private static byte[] getChartBytes(String imageLocation) {		
		byte[] chartBytes = null;
		CheckURL m_CheckURL = new CheckURL(imageLocation, true);
		Thread check = new Thread(m_CheckURL);
		check.run();
		try {
			chartBytes = (byte[]) m_CheckURL.getResult();
		} catch (Exception e) {
		}
		m_CheckURL=null;		
		return chartBytes;
	}

}
