package com.polycom.sampleapps.servlet.weather;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;

import javax.imageio.ImageIO;
/**
*
* <p>Title: WeatherBmpConverter</p>
*
* <p>Description: Creates weather symbols for given weather info</p>
*
* <p>Copyright:* Copyright (c) 2007 Polycom Canada Ltd.</p>
*
* <p>Company: Polycom, Inc</p>
*
* @author M Sandeep
* @version 1.0
*/
public class WeatherBmpConverter
{
	public static void convertToBmp(WeatherInfo a_weatherInfo,
									String a_filePath) throws Exception
	{
		try
		{
			if ( a_weatherInfo != null && a_weatherInfo.isValid() )
			{
				BufferedImage source = ImageIO.read(new ByteArrayInputStream(
					a_weatherInfo.getLocationImageBytes()));
				ImageIO.write(source, "bmp", new File(a_filePath));
			}
		}
		catch (Exception ex)
		{
		}
	}
}
