package com.polycom.sampleapps.servlet.weather;

import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;

/**
*
* <p>Title: WeatherDataProcessor</p>
*
* <p>Description: Updates the weather content for every 15 min through socket channel using NIOForWeather client
* It also start the WeatherBMPMaker which uses the updated data for converting them into weatherinfo objects</p>
*
* <p>Copyright:* Copyright (c) 2007 Polycom Canada Ltd.</p>
*
* <p>Company: Polycom, Inc</p>
*
* @author M Sandeep
* @version 1.0
*/
public class WeatherDataProcessor extends Thread {

	private WeatherManager m_weatherManager;
	private WeatherBMPMaker bmpConverter;
	private NIOForWeather client;

	public WeatherDataProcessor(WeatherManager weatherManager) {
		m_weatherManager = weatherManager;
		bmpConverter = new WeatherBMPMaker(m_weatherManager);
		bmpConverter.start();
	}

	public void run() {
		while ( true )
		{
//			 GET ALL ACTIVE SYMBOLS FROM MGR and check if is accesed in past 5 min or not.If yes then update only those weather items
			Vector<String> symbols = m_weatherManager.getActiveItems();
			
			long currTime = System.currentTimeMillis();		
			Vector<String> temp=new Vector<String>();
			HashMap<String, Long> stockAccessMap = m_weatherManager.getWeatherAccessMap();
			for(String symbol:symbols)
			{
				if(stockAccessMap.containsKey(symbol)&&
						(currTime-stockAccessMap.get(symbol))>ApplicationContext.UNUSED_PERIOD)
				{
					//m_stockMgr.delete(symbol);
				}				
				else if(!stockAccessMap.containsKey(symbol))
				{
					//m_stockMgr.delete(symbol);
				}else
				{
					temp.add(symbol);
				}
			}
			//System.out.println("Weather items size:"+temp.size());
			
				if(symbols.size()>0)
				{
					client = new NIOForWeather(temp, bmpConverter);
					//ApplicationContext.logger.log(Level.INFO, "Weather updated at"+new Date());
				}
				try
				{
					this.sleep(Constants.WEATHER_REFRESH_RATE);
					if(client!=null)
					{
						client.shutDownClient();
						client = null;
					}
				}
				catch (Exception e)
				{
					e.printStackTrace();						
				}
				
		
		}
	}

}
