package com.polycom.sampleapps.servlet.weather;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;

import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTML.Attribute;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.ContentReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;

/**
 *
 * <p>Title: WeathHtmlParser</p>
 *
 * <p>Description: This class handles HTML tag start and end while parsing the HTML content</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author Venu
 * @version 1.0
 */
public class WeatherHtmlParser extends HTMLEditorKit.ParserCallback
{
	//
	private boolean isCommentParsed = false;
	private boolean isTitleParsed = false;
	private int count = 0;
	private int bTagCount = 0;
	private int bTitleTagCount = 0;
	private int windCount = 0;
	private int humidityCount = 0;

	private String title = "";
	private String temperature = "";
	private String wind = "";
	private String humidity = "";
	private String cloudStatus = "";
	private String locImageSrc = "";

	/**
	 * Returns image url parsed from content
	 * @return String
	 */
	public String getImageURL()
	{
		return locImageSrc;
	}

	/**
	 * Returns temperature value parsed from content
	 * @return String
	 */
	public String getTemperature()
	{
		String temp = temperature;
		temp = temp.substring(0, temp.length() - 2) +
			temp.substring(temp.length() - 1);
		return temp;
	}

	/**
	 * Returns wind value parsed from content
	 * @return String
	 */
	public String getWind()
	{
		return wind;
	}

	/**
	 * Returns humidity value parsed from content
	 * @return String
	 */
	public String getHumidity()
	{
		return humidity;
	}

	/**
	 * Returns cloud status value parsed from content
	 * @return String
	 */
	public String getCloudStatus()
	{
		return cloudStatus;
	}

	/**
	 * Returns title value parsed from content
	 * @return String
	 */
	public String getTitle()
	{
		/*String prefix = "Local Weather Forecast for ";
		   String suffix = " - weather.com";
		 String result = title.substring(title.indexOf(prefix) + prefix.length(),
		  title.indexOf(suffix));*/
		return title;
	}

	public void handleText(char[] data, int pos)
	{
		if (isCommentParsed && count >= 0 && count <= 6)
		{
			String temp = new String(data);
			if (bTagCount == 1)
			{
				cloudStatus = temp;
			}
			else if (bTagCount == 2)
			{
				temperature = temp;
			}
			else if (temp.startsWith("Wind"))
			{
				windCount = 1;
			}
			else if (windCount == 1)
			{
				wind = temp;
				windCount = 0;
			}
			else if (temp.startsWith("Humidity"))
			{
				humidityCount = 1;
			}
			else if (humidityCount == 1)
			{
				humidity = temp;
				humidityCount = 0;
			}
			if (temp.indexOf("radar") == -1 && temp.indexOf("NEW") == -1 &&
				temp.indexOf("Updated") == -1)
			{
				//result.append(data);
			}

		}
		else if (!isCommentParsed && bTitleTagCount == 1)
		{
			String temp = new String(data);
			if (temp.equalsIgnoreCase("Right Now for"))
			{
				bTitleTagCount = 2;
			}
		}
		else if (!isCommentParsed && bTitleTagCount == 3)
		{
			title = new String(data);
			bTitleTagCount = 4;
		}
		/*else if (isTitleParsed)
		   {
		 title = new String(data);
		 isTitleParsed = false;
		   }*/
	}

	public void handleComment(char[] data, int pos)
	{
		//<!-- END WEATHER FOR YOUR LIFE -->
		String str = new String(data);
		if (str.indexOf("END WEATHER FOR YOUR LIFE") != -1)
		{
			isCommentParsed = true;
		}
	}

	public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos)
	{
		if (t.equals(HTML.Tag.TABLE))
		{
			if (isCommentParsed && count >= 0 && count <= 6)
			{
				//result.append("<table>" + "\n");
				count++;
			}
		}
		else if (t.equals(HTML.Tag.TR))
		{
			if (isCommentParsed && count >= 0 && count <= 6)
			{
				//result.append("<tr>" + "\n");
			}
		}
		else if (t.equals(HTML.Tag.TD))
		{
			if (isCommentParsed && count >= 0 && count <= 6)
			{
				//result.append("<td valign=\"top\">");
			}
		}
		/*else if (t.equals(HTML.Tag.TITLE))
		   {
		 isTitleParsed = true;
		   }*/
		else if (t.equals(HTML.Tag.B))
		{
			if (!isCommentParsed)
			{
				bTitleTagCount = 1;
			}
			else if (isCommentParsed && count >= 0 && count <= 6 &&
					 bTagCount < 3)
			{
				bTagCount++;
				//result.append("<br>");
			}
		}
	}

	public void handleEndTag(HTML.Tag t, int pos)
	{
		if (t.equals(HTML.Tag.TABLE))
		{
			if (isCommentParsed && count >= 0 && count <= 6)
			{
				//result.append("</table>" + "\n");
				if (count == 6)
				{
					count++;
				}
			}
		}
		else if (t.equals(HTML.Tag.TR))
		{
			if (isCommentParsed && count >= 0 && count <= 6)
			{
				//result.append("</tr>" + "\n");
			}
		}
		else if (t.equals(HTML.Tag.TD))
		{
			if (isCommentParsed && count >= 0 && count <= 6)
			{
				//result.append("</td>" + "\n");
			}
		}
	}

	public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos)
	{
		if (t == HTML.Tag.IMG)
		{
			if (isCommentParsed && count >= 0 && count <= 6)
			{
				Enumeration enum1 = a.getAttributeNames();
				while (enum1.hasMoreElements())
				{
					Attribute attr = (Attribute) enum1.nextElement();
					String value = (String) a.getAttribute(attr);
					if (attr.toString().equalsIgnoreCase("src"))
					{
						if (value.indexOf("blank") == -1 &&
							value.indexOf("pressure") == -1)
						{
							if(!value.contains("videoIcon"))
							{
								locImageSrc = value;
								//System.out.println(locImageSrc);
							}
							//result.append("<img src=\"" + value + "\">");
						}
						break;
					}
				}
			}
		}
		else if (t.equals(HTML.Tag.BR))
		{
			if (bTitleTagCount == 2)
			{
				bTitleTagCount = 3;
			}
			else if (isCommentParsed && count >= 0 && count <= 6)
			{
				//result.append("<br>");
			}
		}
	}

	public void handleError(String errorMsg, int pos)
	{
	}

	/**
	 * Reads and parses weather content
	 * @param a_url String
	 * @param a_timeout String
	 * @throws Exception
	 */
	public void readWeatherContent(String a_url) throws
		Exception
	{
		BufferedReader reader = null;
		try
		{
			String content = a_url;
			HTMLEditorKit.Parser parser;
			parser = new ParserDelegator();
			reader = new BufferedReader(new InputStreamReader(new
				ByteArrayInputStream(content.getBytes())));
			parser.parse(reader, this, true);
		}
		catch (Exception e)
		{
			this.flush();
			if (reader != null)
			{
				reader.close();
			}
			throw e;
		}
		finally
		{
			this.flush();
			if (reader != null)
			{
				reader.close();
				reader = null;
			}
		}
	}

	public static void main(String[] args)
	{
		try
		{
			WeatherHtmlParser parser = new WeatherHtmlParser();
			parser.readWeatherContent("http://www.weather.com/weather/local/INXX0001");
		}
		catch (Exception ex)
		{
		}
	}
}
