package com.polycom.sampleapps.servlet.weather;

public final class WeatherInfo
{
	private String m_title;
	private String m_temperature;
	private String m_humidity;
	private String m_cloudStatus;
	private String m_wind;
	private byte[] m_locImgBytes;
	private String m_filename;

	public WeatherInfo(String a_title, String a_temperature, String a_humidity,
					   String a_cloudStatus, String a_wind,
					   byte[] a_locImgBytes,String a_filename)
	{
		m_title = a_title;
		m_temperature = a_temperature;
		m_humidity = a_humidity;
		m_cloudStatus = a_cloudStatus;
		m_wind = a_wind;
		m_locImgBytes = a_locImgBytes;
		m_filename=a_filename;
	}

	public String getTemperature()
	{
		return m_temperature;
	}

	public String getWind()
	{
		return m_wind;
	}

	public String getHumidity()
	{
		return m_humidity;
	}

	public String getCloudStatus()
	{
		return m_cloudStatus;
	}

	public String getTitle()
	{
		return m_title;
	}

	public byte[] getLocationImageBytes()
	{
		return m_locImgBytes;
	}

	public boolean isValid()
	{
		boolean result = true;
		if (m_title == null || m_temperature == null || m_cloudStatus == null ||
			m_humidity == null || m_wind == null || m_locImgBytes == null)
		{
			result = false;
		}
		return result;
	}

	public String toString()
	{
		return getTitle();
	}

	public void setBMPFileName(String fileName)
	{
		m_filename=fileName;
	}
	
	public String getBmpFileName() {
		return m_filename;
	}
}
