package com.polycom.sampleapps.servlet.weather;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;

import javax.swing.text.BadLocationException;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.ContentReader;
import com.polycom.sampleapps.servlet.common.Reader;
import com.polycom.sampleapps.servlet.common.RefreshManager;

public class WeatherReader implements Reader
{
	public static final String WEATHER_CONTENT_PROVIDER_URL =
		"http://www.weather.com/weather/local";
	private static WeatherReader m_self;
	private Hashtable<String, WeatherInfo> m_weatherInfoTable;
	private Hashtable<String, Long> m_weatherAccessedTimeTable;
	private RefreshManager m_manager;

	private WeatherReader(RefreshManager a_manager)
	{
		m_manager = a_manager;
		m_weatherInfoTable = new Hashtable<String, WeatherInfo> ();
		m_weatherAccessedTimeTable = new Hashtable<String, Long> ();
	}

	public static WeatherReader getInstance(RefreshManager a_manager)
	{
		if (m_self == null)
		{
			m_self = new WeatherReader(a_manager);
		}
		return m_self;
	}

	/**
	 * Checks for last accssed time, if it exceeds beyond the specified accessed time, then unregister this location from cache.
	 * If it is with in specified access time limit, reads location content from content provider site for specified location.
	 * After reading, parses the HTML content and create weather info object and then caches it.
	 * @param a_itemName String
	 * @return Object
	 */
	public Object read(String a_itemName)
	{
		//ApplicationContext.logger.log(Level.INFO, a_itemName + " READING STARTED...........");
		WeatherInfo weatherInfo = null;
		while (true)
		{
			WeatherHtmlParser htmlParser = null;
			BufferedImage source = null;
			try
			{

				// CHECKING FOR LAST ACCESSED TIME, IF IT IS MORE THAN 5 MINS, THEN UNREGISTER THIS ITEM
				Object obj = m_weatherAccessedTimeTable.get(a_itemName);
				if (obj != null)
				{
					long lastAccessedTime = ( (Long) obj).longValue();
					long currentTime = System.currentTimeMillis();
					long meanTime = currentTime - lastAccessedTime;
					if (meanTime >= Constants.UNREGISTER_ITEM_FROM_CACHE_TIME)
					{
						m_weatherAccessedTimeTable.remove(a_itemName);
						m_manager.unregister(a_itemName);
						return weatherInfo;
					}
				}
				// READ AND PARSE WEATHER CONTENT FROM CONTENT PROVIDER URL
				String url = WEATHER_CONTENT_PROVIDER_URL + "/" + a_itemName;
				htmlParser = new WeatherHtmlParser();
				htmlParser.readWeatherContent(url);				
				// NOW READ BYTE CONTENT OF LOCATION STATUS IMAGE
				byte[] chartBytes = ContentReader.getByteContent(htmlParser.
					getImageURL());
				// CREATING WEATHER INFO TO CACHE THE INFORMATION FOR THE SPECIFIED LOCATION.
				if(chartBytes!=null&&chartBytes.length>0)
				{
				/*weatherInfo = new WeatherInfo(htmlParser.getTitle(),
											  htmlParser.getTemperature(),
											  htmlParser.getHumidity(),
											  htmlParser.getCloudStatus(),
											  htmlParser.getWind(), chartBytes);*/
				m_weatherInfoTable.put(a_itemName, weatherInfo);
				break;
				}
				else
				{
					m_weatherAccessedTimeTable.remove(a_itemName);
					m_manager.unregister(a_itemName);
					break;
				}
			}
			catch (IOException ex)
			{
				ApplicationContext.logger.log(Level.INFO, "Could not found Weather");
			}
			catch (Exception ex)
			{
				ApplicationContext.logger.log(Level.SEVERE, a_itemName + "Got exception in Weather reader : " + ex.getMessage());
			}
			finally
			{
				if (source != null)
				{
					source.flush();
					source = null;
				}
				if (htmlParser != null)
				{
					try
					{
						htmlParser.flush();
					}
					catch (BadLocationException ex1)
					{
					}
					htmlParser = null;
				}
				break;
			}
		}
		return weatherInfo;
	}

	/**
	 * Updates the last accessed time and returns the latest weather information.
	 * @param a_itemName String
	 * @return Object
	 */
	public Object getResult(String a_itemName)
	{
		m_weatherAccessedTimeTable.put(a_itemName, System.currentTimeMillis());
		WeatherInfo wInfo = m_weatherInfoTable.get(a_itemName);
		return wInfo;
	}

	public void deleteCache(String a_itemName)
	{
		m_weatherInfoTable.remove(a_itemName);
		m_weatherAccessedTimeTable.remove(a_itemName);
	}
}
