package com.test.bandwidth;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultClientIOEventDispatch;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.protocol.BufferingHttpClientHandler;
import org.apache.http.nio.protocol.HttpRequestExecutionHandler;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExecutionContext;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.EntityUtils;

import com.polycom.sampleapps.servlet.stocks.SymbolKey;

public class FetchProcessor extends Thread {
	public FetchProcessor()
	{

	}
	
	public Vector load()
	{
		Vector vec = new Vector();
		vec.add("http://rss.news.yahoo.com/rss/topstories");
		vec.add("http://rss.news.yahoo.com/rss/us");
		vec.add("http://rss.news.yahoo.com/rss/sept11");
		vec.add("http://rss.news.yahoo.com/rss/terrorism");
		vec.add("http://rss.news.yahoo.com/rss/hurricanekatrina");
		vec.add("http://rss.news.yahoo.com/rss/world");
		vec.add("http://rss.news.yahoo.com/rss/mideast");
		vec.add("http://rss.news.yahoo.com/rss/iraq");
		vec.add("http://rss.news.yahoo.com/rss/politics");
		vec.add("http://rss.news.yahoo.com/rss/elections");
		vec.add("http://rss.news.yahoo.com/rss/business");
		vec.add("http://rss.news.yahoo.com/rss/tech");
		vec.add("http://rss.news.yahoo.com/rss/sports");
		vec.add("http://rss.news.yahoo.com/rss/entertainment");
		vec.add("http://rss.news.yahoo.com/rss/health");
		vec.add("http://rss.news.yahoo.com/rss/oddlyenough");
		vec.add("http://rss.news.yahoo.com/rss/science");
		vec.add("http://rss.news.yahoo.com/rss/oped");
		vec.add("http://rss.news.yahoo.com/rss/hotzone");
		vec.add("http://rss.news.yahoo.com/rss/crime");
		vec.add("http://rss.news.yahoo.com/rss/obits");
		vec.add("http://rss.news.yahoo.com/rss/mostemailed");
		vec.add("http://rss.news.yahoo.com/rss/mostviewed");
		vec.add("http://rss.news.yahoo.com/rss/highestrated");
		return vec;
	}
	public void run()
	{
		while (true) {
			String url = "http://rss.news.yahoo.com/rss/topstories";
			Vector vec = load();
			
			FetchData client = new FetchData(vec, false);
			try {
				this.sleep(1 * 60 * 1000);
				if (client != null) {
					client.shutDownClient();
					client = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	class FetchData {

		private BasicHttpParams params;
		private BasicHttpProcessor httpproc;
		private String m_url;
		private Object result;
		private boolean m_isByteData;
		private ConnectingIOReactor ioReactor;
		private Vector<String> m_currentActiveNewsVec;

		public FetchData(Vector<String> currentActiveNewsVec, boolean isByteData) {
			m_currentActiveNewsVec = currentActiveNewsVec;
			m_isByteData = isByteData;
			final HttpParams params = new BasicHttpParams(null);
			params
					.setIntParameter(HttpConnectionParams.SO_TIMEOUT, 50000)
					.setIntParameter(HttpConnectionParams.CONNECTION_TIMEOUT,
							70000)
					.setIntParameter(HttpConnectionParams.SOCKET_BUFFER_SIZE,
							8 * 1024)
					.setBooleanParameter(
							HttpConnectionParams.STALE_CONNECTION_CHECK, false)
					.setBooleanParameter(HttpConnectionParams.TCP_NODELAY, true)
					.setParameter(HttpProtocolParams.USER_AGENT,
							"Jakarta-HttpComponents-NIO/1.1");

			try {
				ioReactor = new DefaultConnectingIOReactor(2, params);
				BasicHttpProcessor httpproc = new BasicHttpProcessor();
				httpproc.addInterceptor(new RequestContent());
				httpproc.addInterceptor(new RequestTargetHost());
				httpproc.addInterceptor(new RequestConnControl());
				httpproc.addInterceptor(new RequestUserAgent());
				httpproc.addInterceptor(new RequestExpectContinue());

				BufferingHttpClientHandler handler1 = new BufferingHttpClientHandler(
						httpproc, new MyNewsHttpRequestExecutionHandler(),
						new NoConnectionReuseStrategy(), params);

				BufferingHttpClientHandler handler = new BufferingHttpClientHandler(
						httpproc, new MyNewsHttpRequestExecutionHandler(),
						new DefaultConnectionReuseStrategy(), params);

				// handler.setEventListener(new EventLogger());
				final IOEventDispatch ioEventDispatch = new DefaultClientIOEventDispatch(
						handler1, params);

				Thread t = new Thread(new Runnable() {
					public void run() {
						try {
							ioReactor.execute(ioEventDispatch);
						} catch (InterruptedIOException ex) {
							System.err.println("Interrupted");
						} catch (IOException e) {
							System.err.println("I/O error: " + e.getMessage());
						}
					}
				});
				t.start();

				SessionRequest[] reqs = new SessionRequest[m_currentActiveNewsVec.size()];
				for (String newsRSS : m_currentActiveNewsVec) {
					URL url = new URL(newsRSS);
					String hostAddress = url.getHost();
					String uri = url.getPath();
					SymbolKey quoteKey = new SymbolKey(uri, new HttpHost(hostAddress));
				    reqs[0] = ioReactor.connect(new InetSocketAddress(hostAddress,80), null, quoteKey, null);
				}

			}
			catch (Exception e) {
			}
		}

		public void shutDownClient() {

			try {
				if (ioReactor != null)
					ioReactor.shutdown();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

		class MyNewsHttpRequestExecutionHandler implements
				HttpRequestExecutionHandler {

			public void initalizeContext(final HttpContext context,
					final Object attachment) {
				// HttpHost targetHost = (HttpHost) attachment;
				SymbolKey chartKey = (SymbolKey) attachment;
				context.setAttribute("URI", chartKey.getURI());
				context.setAttribute(HttpExecutionContext.HTTP_TARGET_HOST,
						chartKey.getHttpHost()); // targetHost);
				System.out.println("In initialize");
			}

			public HttpRequest submitRequest(final HttpContext context) {

				HttpHost targetHost = (HttpHost) context
						.getAttribute(HttpExecutionContext.HTTP_TARGET_HOST);
				String uri = (String) context.getAttribute("URI");
				BasicHttpRequest req = new BasicHttpRequest("GET", uri);
				System.out.println("In submit");
				/*
				 * counter++; if(counter>1) return null;
				 */
				return req;
			}

			public void handleResponse(final HttpResponse response,
					final HttpContext context) {
				HttpEntity entity = response.getEntity();
				String url = "";
				HttpHost host = (HttpHost) context
						.getAttribute("http.target_host");
				url += host.getSchemeName() + "//" + host.getHostName();
				String uri = (String) context.getAttribute("URI");
				url += uri;
				if (!uri.equals("")) {
					System.out.println("URL<"+url+">:"
							+ entity.getContentLength());
					
					try {
						if (m_isByteData)
							result = EntityUtils.toByteArray(entity);
						else
							result = EntityUtils.toString(entity);
					} catch (IOException e) {
						e.printStackTrace();
					}

							
				}
			}

		}

		public Object getResult() {
			return result;
		}

	}

	public static void main(String[] args) {

		/*
		 * String url = "http://rss.news.yahoo.com/rss/topstories"; FetchData nn =
		 * new FetchData(url, false);
		 */
		FetchProcessor check = new FetchProcessor();
		check.run();
	}
}